<?php
require_once '../config.php';
requireLogin();

header('Content-Type: application/json');

// FIXED: Use null coalescing operator to prevent undefined index errors
$topic = $_POST['topic'] ?? '';
$content = $_POST['content'] ?? '';
$word_count = $_POST['word_count'] ?? 0;
$content_type = $_POST['content_type'] ?? 'article';
$tone = $_POST['tone'] ?? 'professional';
$ai_persona = $_POST['ai_persona'] ?? 'lily-seo';

try {
    $db = getDB();
    $stmt = $db->prepare("INSERT INTO generated_content (user_id, topic, content, word_count, content_type, tone, ai_persona) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$_SESSION['user_id'], $topic, $content, $word_count, $content_type, $tone, $ai_persona]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Content saved successfully'
    ]);
} catch (Exception $e) {
    error_log("Save content error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => 'Failed to save content: ' . $e->getMessage()
    ]);
}
?>